<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_ControllerPublic_Account extends XFCP_sonnbStopSpamHere_ControllerPublic_Account
{
    public function actionPersonalDetailsSave()
    {
        $this->_assertPostOnly();

        $about = $this->getHelper('Editor')->getMessageText('about', $this->_input);
        $about = XenForo_Helper_String::autoLinkBbCode($about);
        $sshModel = sonnbStopSpamHere_Model_SSH::getInstance();
        
        if ($sshModel->_hasLinkCheck('personal_detail'))
        {
            $return = $sshModel->checkLink(sonnbStopSpamHere_Model_SSH::TYPE_PERSONALDETAIL, 0, $about);

            if ($return)
            {                
                $return['data']['content_link'] = XenForo_Link::buildPublicLink('full:account/personal-details', $sshModel->visitor);
                
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_LINK,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':                        
                        $this->throwError('link', array(
                            'post'=> $sshModel->options->sonnbStopSpamHere_linkDisabledPostCount, 
                            'day'=> $sshModel->options->sonnbStopSpamHere_linkDisabledJoinDate
                        ));
                        break;
                    case 'moderate':
                    case 'pc':
                    case 'report':
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PERSIONALDETAIL_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        if ($sshModel->_hasKeywordCheck('personal_detail'))
        {
            $return = $sshModel->checkKeyword(sonnbStopSpamHere_Model_SSH::TYPE_PERSONALDETAIL, 0, $about);

            if ($return)
            {                
                $return['data']['content_link'] = XenForo_Link::buildPublicLink('full:account/personal-details', $sshModel->visitor);
                
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_KEYWORD,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError('keyword', array(
                            'keywords'=>implode('","', $return['data']['matches'])
                        ));
                        break;
                    case 'moderate':
                    case 'pc':
                    case 'report':
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PERSIONALDETAIL_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }

        if ($sshModel->_hasAkismetCheck('personal_detail'))
        {
            $return = $sshModel->checkAkismet(sonnbStopSpamHere_Model_SSH::TYPE_PERSONALDETAIL, 0, $about);
            
            if ($return)
            {                
            	$return['data']['content_link'] = XenForo_Link::buildPublicLink('full:account/personal-details', $sshModel->visitor);
            	
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_AKISMET,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':                       
                        $this->throwError();
                        break;
                    case 'moderate':
                    case 'pc':
                    case 'report': 
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PERSIONALDETAIL_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        return parent::actionPersonalDetailsSave();
    }

    public function actionSignatureSave()
    {
        $this->_assertPostOnly();

        $signature = $this->getHelper('Editor')->getMessageText('signature', $this->_input);
        $signature = XenForo_Helper_String::autoLinkBbCode($signature);
        $sshModel = sonnbStopSpamHere_Model_SSH::getInstance();
        
        if ($sshModel->_hasLinkCheck('signature'))
        {
            $return = $sshModel->checkLink(sonnbStopSpamHere_Model_SSH::TYPE_SIGNATURE, 0, $signature);

            if ($return)
            {       
                $return['data']['content_link'] = XenForo_Link::buildPublicLink('full:account/signature', $sshModel->visitor);
                          
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_LINK,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':                        
                        $this->throwError('link', array(
                            'post'=> $sshModel->options->sonnbStopSpamHere_linkDisabledPostCount, 
                            'day'=> $sshModel->options->sonnbStopSpamHere_linkDisabledJoinDate
                        ));
                        break;
                    case 'moderate':
                    case 'pc':
                    case 'report':
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_SIGNATURE_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        if ($sshModel->_hasKeywordCheck('signature'))
        {
            $return = $sshModel->checkKeyword(sonnbStopSpamHere_Model_SSH::TYPE_SIGNATURE, 0, $signature);

            if ($return)
            {
                $return['data']['content_link'] = XenForo_Link::buildPublicLink('full:account/signature', $sshModel->visitor);
            
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_KEYWORD,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError('keyword', array(
                            'keywords'=>implode('","', $return['data']['matches'])
                        ));
                        break;
                    case 'moderate':
                    case 'pc':
                    case 'report':
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_SIGNATURE_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }

        if ($sshModel->_hasAkismetCheck('signature'))
        {
            $return = $sshModel->checkAkismet(sonnbStopSpamHere_Model_SSH::TYPE_SIGNATURE, 0, $signature);

            if ($return)
            {
                $return['data']['content_link'] = XenForo_Link::buildPublicLink('full:account/signature', $sshModel->visitor);
            
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_AKISMET,
                    'data' => array('content_link' => XenForo_Link::buildPublicLink('full:account/signature'))
                );
                
                switch ($return['action'])
                {
                    case 'block':                       
                        $this->throwError();
                        break;
                    case 'moderate':
                    case 'pc':
                    case 'report': 
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_SIGNATURE_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        return parent::actionSignatureSave();
    }
    
    public function throwError($type='default', $data = array())
    {
        $params = array();
        switch ($type)
        {
            case 'link':
                $params = $data;
                if (empty($params['post']) && !empty($params['day']))
                {
                    $type .= '_day';
                }
                elseif (empty($params['day']) && !empty($params['post']))
                {
                    $type .= '_post';
                }
                elseif (empty($params['day']) && empty($params['post']))
                {
                    $type .= '_no_reason';
                }
                break;
            case 'keyword':
                $params = $data;
                break;
            case 'default':
            default:
                $params = array('contactUrl' => sonnbStopSpamHere_Model_Log::getContactUrl());
                break;
        }
        
        throw $this->responseException(
                $this->responseError(
                        new XenForo_Phrase(
                                'sonnbStopSpamHere_post_stop_message_'.$type,
                                $params
                            )
                        , 403)
                );
    }

}
?>